local assets =
{
	Asset("ANIM", "anim/unit_center.zip"),
    Asset("ATLAS", "images/inventoryimages/unit_center.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("unit_center")
    inst.AnimState:SetBuild("unit_center")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "unit_center"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/unit_center.xml"
    inst:AddComponent("selfstacker")
    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("unit_center", fn, assets)